package Parp::IdCache;

use strict;

use DB_File;
use Fcntl qw(:DEFAULT);

use MyFilter qw(%CONFIG);

use base qw(Exporter);
use vars qw(@EXPORT_OK);
@EXPORT_OK = qw(is_duplicate);


my @dup_ids = ();

sub init {
  if (exists $CONFIG{id_cache}) {
    tie @dup_ids, 'DB_File', $CONFIG{id_cache}, O_CREAT | O_RDWR, 0600,
      $DB_RECNO;
  }
}

sub is_duplicate {
  my ($id) = @_;

  # Ugh.  Wish there were tie-able dual array/hash data structures.
  # TODO: Maybe there are.  Find out.
  foreach my $cached_id (@dup_ids) {
    if ($id eq $cached_id) {
      return 1;
    }
  }

  return 0;
}

sub add_id {
  my ($id) = @_;
  
  push @dup_ids, $id;
  shift @dup_ids if @dup_ids > $CONFIG{max_cache_ids};
}

1;

