package Parp::Friends;

use strict;

use DB_File;
use Fcntl qw(:DEFAULT);

use MyFilter qw(%CONFIG);
use Parp::Utils qw(check_file_dir);

use base qw(Exporter);
use vars qw(@EXPORT_OK);
@EXPORT_OK = qw(have_friends is_friend make_friend);


my %friends = ();

sub init {
  if (exists $CONFIG{friends_db}) {
    check_file_dir($CONFIG{friends_db});
    tie %friends, 'DB_File', $CONFIG{friends_db}, O_RDWR | O_CREAT, 0600;
  }
}

sub have_friends { tied %friends }

sub is_friend { $friends{$_[0]} }

sub make_friend {
  my ($new_friend, $reason) = @_;
  $friends{$new_friend} = $reason;
}

END {
  # Avoid `1 inner references still exist' warnings
  my $tied = (tied %friends) ? 1 : 0;
  $tied and untie %friends;
}


1;
