package Parp::Config::User;

use strict;
use warnings;

# perldoc Parp::Config for which methods are available for
# overridding, and what their defaults are.
use base 'Parp::Config';

sub me {
  # Addresses I currently want to receive mail to
  qr/
     adam\@spiers\.net                                      |
     (adams?|aspiers|translations|bugzilla-admin|cvs-admin)
       \@guideguide\.com                                    |
     aspiers\@cpan\.org                                     |
     .*@(adamspiers|tigerpig)\.org                          |
     adamspiers\@users\.sourceforge\.net                    |
#    8439\@excite\.com|associate                            |
     this_should_never_match
    /ix;
}

sub old_me {
  # Old addresses I don't want people to use any more
  qr/
     adam\.spiers\@musician\.org                         |
     a\.?spiers\@ram\.ac\.uk                             |
     adam\.spiers\@new\.ox(ford)?.ac.uk                  |
     (adam(-.+)?|irc.*|peanuts|it-support|zsh-mirror(-.+)?)
       \@(thelonious|corelli)\.new\.ox\.ac\.uk           |
     m93asp\@(.+\.)?ecs\.ox\.ac\.uk                      |
     (adams?|aspiers)\@mediaconsult\.com                 |
     newc0115\@sable\.ox\.ac\.uk
    /ix;
}

sub decoys {
  # Decoy addresses I hand out to people who I don't trust not to
  # spam me.  e-mail to these addresses still comes to me, but makes
  # for very easy filtering.
  qr/(
      adam-spam(-.+)?\@thelonious\.new\.ox\.ac\.uk
     )/ix;
}

# Addresses similar to mine.  If an e-mail has more recipients
# matching this than the threshold specified, it must be a spam
# which has been sent to everyone in a massive alphabetically
# sorted list.
sub like_me { qr/adam.*\@/ }
       
sub good_domains {
  # Domains I really trust
  qr/
     [.@]
     (
      [\w\.-]+\.ac\.uk        |
      guideguide\.com         |
      mediaconsult\.com       |
      redhat\.com             |
      ibm\.com                |
      valinux\.com            |
      mozilla\.org            |
      infospace\.com          |
      securityfocus\.com
     )
     \b
    /ix;
}

sub subject_buzzwords {
  # If a subject matches this, I want to see the e-mail. 
  qr/\b(
     cello                   |
     chess                   |
     dbm                     |
     fmscore                 |
     freshmeat               |
     guideguide              |
     jazz                    |
#    juggling                |
     Linux                   |
     logfilterd              |
     mozilla                 |
     mysqldiff               |
     nick.?o.?met(er|re)     |
     palm(source)?           |
     parp                    |
     Perl                    |
     pjb                     |
     plig                    |
     plucker                 |
     quietrun                |
     sawfish                 |
     seamonkey               |
     shells?                 |
     thinkpad                |
     tigerpig                |
     ttm                     |
     uri                     |
     visor                   |
     zsh 
   )\b/ix;
}

sub password { 'fragglerock' }

1;
