package Parp::Friends;

=head1 NAME

Parp::Friends - friends database management

=head1 SYNOPSIS

Used internally.

=head1 DESCRIPTION

This module provides routines for managing the database of known
friends.

=cut

use strict;
use warnings;

use DB_File;
use Fcntl qw(:DEFAULT);

use Parp::Config qw(config);
use Parp::Utils qw(check_file_dir fatal);
use Parp::Locking;

use base qw(Exporter);
our @EXPORT_OK = qw(is_friend make_friend break_friend);

my %friends = ();

sub init {
  my $db = config->friends_db;
  check_file_dir($db);
  lock_ident('Friends');
  tie %friends, 'DB_File', $db, O_RDWR | O_CREAT, 0600
    or fatal "Failed to tie $db as Berkeley DB: $1\n";
}

sub is_friend { $friends{$_[0]} }

sub make_friend {
  my ($new_friend, $reason) = @_;
  $friends{$new_friend} = $reason;
}

sub break_friend {
  my ($ex_friend) = @_;
  delete $friends{$ex_friend};
}

END {
  # Avoid `1 inner references still exist' warnings
  my $tied = (tied %friends) ? 1 : 0;
  $tied and untie %friends;
}


1;
