package Parp::Options;

use strict;
use warnings;

use Getopt::Std;

use base qw(Exporter);
our @EXPORT_OK = qw(usage opt opts);

my %options = (
  extract_friends => 0,
  test_run        => 0,
  wrong_class     => 0,
);

sub usage {
  warn <<EOF;
parp $::VERSION -- Perl Anti-spam Replacement for Procmail
(c) 1999--2001 Adam Spiers <adam\@spiers.net>

Usage:
  parp [ options ] < email
  parp [ options ] -f folder1 [ folder2 ... ]

Options:
  -d       enable discarding of duplicates (by Message-Id header)
  -D<DIR>  run in daemon mode, using DIR as the incoming queue
  -e       only extract e-mail addresses and add them to friends database
  -f       operate on given files rather than as a filter
  -p       dry run for pipes - don't actually execute pipe commands
  -r       enable blacklist checking (see http://mail-abuse.org/rss/)
  -s<NUM>  with -f, only sample a maximum of <num> messages per folder
  -t       test run - just show what would have been done
  -v       increase verbosity
  -w       only log that filter's spam detection heuristics failed on
           the supplied mails; don't do anything else
EOF

  exit 2;
}

sub process {
  my %opts = ();
  getopts('edD:fhmprs:tvw', \%opts);
  usage() if $opts{h};

  my %long_names = (
    'd' => 'no_dups',
    'D' => 'daemon',
    'e' => 'extract_friends', 
    'f' => 'filter_files',
    'p' => 'dry_pipes', 
    'r' => 'do_blacklist', 
    's' => 'sample', 
    't' => 'test_run', 
    'v' => 'verbose', 
    'w' => 'wrong_class', 
  );

  foreach my $letter (keys %long_names) {
    $options{$long_names{$letter}} = $opts{$letter} if defined $opts{$letter};
  }

  usage() if $options{daemon} && $options{filter_files};
  usage() if (  $options{extract_friends}
              + $options{test_run}
              + $options{wrong_class}) > 1;
  $options{test_run}++ if $options{extract_friends};

  eval {
    local $SIG{__DIE__} = sub { die $_[0] }; # blegh
    require Net::DNS;
  } if $options{do_blacklist};
}

sub opt  { $options{$_[0]} }
sub opts { @options{@_   } }


1;
