package Parp::Friends;

use strict;
use warnings;

use DB_File;
use Fcntl qw(:DEFAULT);

use Parp::Config qw(config);
use Parp::Utils qw(check_file_dir);
use Parp::Locking;

use base qw(Exporter);
our @EXPORT_OK = qw(have_friends is_friend make_friend);

my %friends = ();

sub init {
  my $db = config->friends_db();
  if ($db) {
    check_file_dir($db);
    lock_ident('Friends');
    tie %friends, 'DB_File', $db, O_RDWR | O_CREAT, 0600;
  }
}

sub have_friends { tied %friends }

sub is_friend { $friends{$_[0]} }

sub make_friend {
  my ($new_friend, $reason) = @_;
  $friends{$new_friend} = $reason;
}

END {
  # Avoid `1 inner references still exist' warnings
  my $tied = (tied %friends) ? 1 : 0;
  $tied and untie %friends;
}


1;
