# URI::Bookmarks::Mozilla --
# Perl module containing routines for Mozilla bookmark files
#
# Copyright (c) 2000 Adam Spiers <adam@spiers.net>. All rights
# reserved. This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
#
# $Id: Mozilla.pm,v 1.1 2000/06/07 19:44:29 localadams Exp $
#

package URI::Bookmarks::Mozilla;

use strict;

require 5.004;
use AutoLoader qw(AUTOLOAD);
use Carp;
use URI::Bookmark::Mozilla;
use URI::Bookmark::Netscape;
use URI::Bookmarks;

=head1 NAME

URI::Bookmarks::Mozilla - Perl module containing routines for
Mozilla bookmark files

=head1 SYNOPSIS

  See L<URI::Bookmarks>.

=head1 DESCRIPTION

URI::Bookmarks::Mozilla contains some helper routines specifically
for URI::Bookmarks objects which were originally Mozilla bookmark
files.

=cut

use vars qw(@ISA);
@ISA = qw(URI::Bookmarks::Netscape);


1;
########################    End of preloaded code    ########################
__END__

##############################################################################
# end of methods
##############################################################################

sub pre_output_node {
  my ($node, $options) = @_;
  my $lines = $options->{lines};

  my $indent = ' ' x (4 * ($options->{_depth} || 0));

  my $type = $node->type;

  if ($type eq 'folder') {
    my $title = $node->name;
    my $HTML_attribs
      = $node->URI::Bookmark::Mozilla::HTML_attribs(qw/FOLDED ADD_DATE 
                                                       PERSONAL_TOOLBAR_FOLDER
                                                       ID/);
    push @$lines, "$indent<DT><H3$HTML_attribs>$title</H3>\n";
  }
  elsif ($type eq 'bookmark') {
    my $title = $node->name;
    my $HTML_attribs
      = $node->URI::Bookmark::Mozilla::HTML_attribs(qw/HREF ALIASOF ALIASID
                                                        ADD_DATE LAST_VISIT
                                                        LAST_MODIFIED/);
    push @$lines, "$indent<DT><A$HTML_attribs>$title</A>\n";
  }
  elsif ($type eq 'rule') {
    push @$lines, "$indent<HR>\n";
  }

  my $description = $node->attribute->{description};
  push @$lines, "<DD>$description" if $description;

  if ($type eq 'folder') {
    push @$lines, "$indent<DL><p>\n";
  }

  return 1;
}

sub post_output_node {
  my ($node, $options) = @_;
  my $lines = $options->{lines};

  my $indent = ' ' x (4 * $options->{_depth});

  if ($node->type eq 'folder') {
    push @$lines, "$indent</DL><p>\n";
  }
}

=head1 AUTHOR

Adam Spiers <adam@spiers.net>

=head1 SEE ALSO

L<URI::Bookmarks>, L<URI::Bookmarks::*>, L<URI::Bookmark>,
L<URI::Bookmark::*>, L<perl(1)>.

=cut

