# URI::Bookmark::Mozilla --
# Perl module containing routines for individual Mozilla bookmarks
#
# Copyright (c) 1999 Adam Spiers <adam@spiers.net>. All rights
# reserved. This program is free software; you can redistribute it and/or
# modify it under the same terms as Perl itself.
#
# $Id: Mozilla.pm,v 1.1 2000/06/07 19:44:29 localadams Exp $
#

package URI::Bookmark::Mozilla;

use strict;

require 5.004;
use URI::Bookmark;
use URI::Bookmark::Netscape;

=head1 NAME

URI::Bookmarks::Mozilla - Perl module containing routines for
individual Mozilla bookmarks

=head1 SYNOPSIS

See L<URI::Bookmarks>.

=head1 DESCRIPTION

URI::Bookmark::Mozilla contains some helper routines specifically for
URI::Bookmark objects which were originally from Mozilla bookmark files.

=cut

*HTML_attribs = \&URI::Bookmarks::Netscape::HTML_attribs;

=head1 AUTHOR

Adam Spiers <adam@spiers.net>

=head1 SEE ALSO

L<URI::Bookmarks>, L<URI::Bookmarks::*>, L<URI::Bookmark>, L<perl(1)>.

=cut

